#!/usr/bin/perl

# The Travesty Corporate PR InfoMixer v.1.0
# Amy Alexander, plagiarist.org, July 2002
# Based on Travesty, part of Perl source distribution.
# Infomixer Copyleft 2002, released under the Gnu Public License (GPL)
# See http://www.gnu.org/licenses/gpl.txt for the GPL

	
	use locale;		# for the case conversion of first character..
	use CGI qw(:standard escapeHTML);
	use File::Basename;
	
	
	
###########################	
### Stuff to configure: 

	# If this script is kept in a directory other than where the supportfiles and remixfiles directories are
	# (such as a cgi-bin directory), what is the URL of the directory where supportfiles and remixfiles are?
	# For example:
	# $infopath="http://mydomain.com/infomix";
	# Be sure to keep the quotes and semicolon intact!
	$infopath = ".";
	
	# If you needed to change the above, please change this one to the UNIX or system directory
	# path of that same directory. 
	# For example: 
	# $infopath="/home/wilma/infomix"; 
	# (You may also use relative paths, if you're familiar with those.)
	# Be sure to keep the quotes and semicolon intact!
	$infosystempath = ".";
	

	
	%selectfiles =  (	# don't touch this line.
	
	# Replace the following with your own company names and filenames, using the same format.
	# You will upload these files to the remixfiles directory.
	# Careful with the quotes and commas!	
	
						'Monsanto', 'monsanto.txt',
		  				'Dupont', 'dupont.txt',
						'Waste Management', 'wm.txt',
						'Microsoft', 'microsoft.txt',
						'Hill and Knowlton', 'hillknowlton.txt',
						'McDonalds', 'mcds.txt',
						'WTO', 'wto.txt',
						'Shell', 'shell.txt',
						'Playboy', 'playboy.txt',
						'Philip Morris', 'philmorris.txt'
						
						); # don't touch this line either.
	
	
	### The remainder of the configuration items are optional!
						
	# Maximum number of words per remix you want. default is 250.
	$doclength = 250;					
							
	
	# What name do you want to call your jam?
	$jamname = "Travesty Corporate PR InfoMix";
	
	
	# What name do you want to call your All-Star Jam? 
	# (that's the version where it remixes every file in the remixfiles directory.)
	$allstarjamname = "All-Star Corporate Remix Jam";
		
# End of stuff to configure. However, if you want to customize it more (text and background
# colors and styles) just edit the styles.css file in the supportfiles directory. And
# you can change the montage image just by replacing the 'montage.jpg' image, also in 
# the supportfiles directory. Happy InfoMixing!
 	
###########################
	
	# $g_dbg=1; # for debugging only
		
	$f1 = param('f1');
	$f2 = param('f2');
	$f3 = param('f3');
	$stew = param('stew');

	$scriptname = basename($0);
	$textdir = "$infosystempath/remixfiles";
	
	srand($$ ^ time);
	$software = $jamname . "er";
	
	@files = split( /\n/, `/bin/ls "$textdir/"` );
	fisher_yates_shuffle(\@files); #shuffle the file order...
	$allfiles = join(" $textdir/",@files); #put in the path...
	$allfiles = "$textdir/$allfiles\n";  #this takes care of the first one, missed by join...
	@allfiles = split(" ",$allfiles);	#this is a mess, could be tidier i'm sure...
	
       
  	foreach my $item ($f1, $f2, $f3) {
		next if $item =~ /^Select Corporate Artist/;	
		if ($item) { 
			
			push (@f, $item) ;
		}
	}
	if (!@f && !$stew) {
	 	printselector();
		exit(0);
	}
	
	my $remixed;

	if  ($stew == 1) {
		$remixed = "$allstarjamname" . "!";
	}	

	else {
		$remixed = join (' vs. ', @f);
		fisher_yates_shuffle(\@f);
		$remixed =~ s/vs.\s*$//g;
		$remixed = $remixed . "!";
	}
	
	foreach my $selection ($f1,$f2,$f3) {
	 	$selection = urlencode("$selection");
	}	
	
	$urlstring="f1=$f1&f2=$f2&f3=$f3&stew=$stew";

	
	
	# here we print out the HTML including the remixed text.
	
	print "Content-type: text/html\n\n";
	print <<"EOF";
	<HTML>
	<HEAD><TITLE>$jamname</TITLE>

	<LINK href="$infopath/supportfiles/styles.css" type=text/css rel=stylesheet>

	</HEAD>
	
   <BODY leftMargin=0 topMargin=0 marginheight="0" marginwidth="0" bgcolor="black">
	<table cellspacing=8 cellpadding=1 width=700 height=450 bgcolor=black border=0>
	<tbody> 
	<tr> 
     <td width="4" height="39"></td>
     <td valign="center" width="132"  bgcolor=#FFFF00 class="corner" style="PADDING-LEFT: 10px"><i>$jamname</i></td>
     <td width="507" valign="center" bgcolor=#0000FF class="titlebar"><img width="6" alt="" src="$infopath/supportfiles/clear.gif" border=0> 
       <i>$remixed</i></td>
     <td width="6"></td>
	</tr>
	<tr> 
     <td height="122"></td>
     <td colspan=2 valign="center" bgcolor=#339900 class="montageblock"> 
       <p><span class="navilinks"><img width="12" alt="" src="$infopath/supportfiles/clear.gif" border=0><img src="$infopath/supportfiles/montage.jpg" width="567" height="72"> 
      	<br>
       <img width="12" alt="" src="$infopath/supportfiles/clear.gif" border=0><a href="$scriptname?$urlstring">NEW 
      	REMIX - SAME ARTISTS' TRACKS</a> <img height=2 alt="" 
       src="$infopath/supportfiles/clear.gif" width=5 border=0>|<img height=2 alt="" 
       src="$infopath/supportfiles/clear.gif" width=5 border=0><a href="$scriptname?">BRAND 
      	NEW REMIX!</a></span> 
     </td>
     <td></td>
	</tr>
	<tr> 
     <td colspan="4"> 
       <table cellspacing="10" border="0" cellpadding="10" width="100%" bgcolor="black">
      	<tr> 
           <!-- text cell -->
           <td class="textbackground" rowspan="3" valign=top style="PADDING-RIGHT: 20px" bgcolor=#006600 width="505"> 
                   <P class=text>
EOF
	
	
	# here we run travesty on selected files or on all files in directory for an all-star jam.
	if  ($stew==1) {
	
		$garble = travesty(@allfiles);
	}
	else	{
		$garble = travesty("$textdir/$selectfiles{$f[0]}", "$textdir/$selectfiles{$f[1]}",
		"$textdir/$selectfiles{$f[2]}");
		
	}	 
	
		
	if ($bugvar >= 10) { # amy hack. here's where we throw away stuff that travesty had to bootstrap.
	   # dbg ("bugvar is $bugvar");
		@garble = split(' ',$garble);
		@badgarble = splice(@garble, 0, $bugvar);
		$garble = join(' ',@garble);
		$badgarble = "@badgarble";
		# dbg ("badgarble was $badgarble");
	}	# end amy hack.

	$garble =~ s/^.+?\.\s+?//ims; #delete first sentence fragment.
	

	$garble =~ s/\d+\.//g; #wipe out numbering - it looks incongrous.
	$garble =~ s/\[\d+\]//g; #wipe out bracketed numbering too.
	$garble =~ s/^\s*(\w)/\U$1/g;  #make sure each line starts with a capital letter.
	$garble =~ s/(<P>\s*)(\w)/$1\U$2/g;  #make sure par breaks are followed by a capital letter.
				    # fix for when non-conventional grammar fools the sentence finder.
	$garble =~ s/<P>/<P class=text>/g; 	#style sheet foo		 
					 
	$garble =~ s/\"//g; #remove quotes, because they look like errors.
					 
	
	$garble =~ s/(.*\.)[^\.]*$/$1/; #lose everything after the last "full" sentence.
	 


	print $garble;

	print <<"EOF";
          </td>
	
	
      
         
    
          <td rowspan="3" valign="top" bgcolor="yellow" width="85" class="sidebar"><img width="85" alt="" src="$infopath/supportfiles/clear.gif" border=0 height="230"></td>
        </tr>
      </table>
    </td>
  </tr>
  </tbody> 
</table>
</BODY></HTML>

	
EOF
	
	
	
sub fisher_yates_shuffle	{  #from perl cookbook pg 121
		
	 my $array = shift;
	 my $i;
	 for ($i = @$array; --$i; ) {
		 my $j = int rand ($i+1);
		 next if $i == $j;
		 @$array[$i,$j] = @$array[$j,$i];
	 }
}

	
sub travesty {
  # a hacked version of the famous travesty program from Programming Perl book, and elsewhere.

  my $returntext = "";
  my $a = ''; 
  my $p = '';
  my $n = ''; # probably not helpful, but oh well.
  my $w;
  my $word;
  my $num;
  my $lookup;
  my $foo;
  my $returntext='';
  $bugvar=0; # global variable, used later for amy's "bugfix"...
 
  # First analyze the input.
  foreach my $infile (@_) {
		
    open IN, "$infile";
    while (<IN>) {

      # Do each word.   
      push(@ary,split(' '));
 
      while ($#ary > 1) {
			
			$a = $p;
			$p = $n; 
			$w = shift(@ary);

		
			$n = $num{$w};
		
			if ($n eq '') {
			  push(@word,$w);
			  $n = pack('S',$#word);
			  $num{$w} = $n;
			} # end if
		
			$lookup{$a . $p} .= $n;
			$debugvar = 1;
      } # end while $#ary
    } # end while <IN>
  }	# end foreach	

	
	
	

  # Now spew out the words, based on the frequencies.  If there
  # is more than one possibility to choose from, choose one
  # randomly.
	
	
	for ($i=1; $i < $doclength; $i++) {

    	$n = $lookup{$a . $p};		
		
		 
	 	# following if/then is amy's hack. a long string of empty n's at the beginning will output real garbage.
	 	# therefore, keep track of how many of these in the string so we can discard later.	 
	 	if ($n eq '') {
	 		# dbg ("n is empty! and i is $i.");
			if ($i - $bugvar < 4) {$bugvar = $i;}
		}	
	 
		($foo,$n) = each(lookup) if $n eq ''; # A bootstrap.
		# not sure what the & is used for here.
		$n = substr($n,int(rand(length($n))) & 0177776,2);

		$a = $p;
		$p = $n;
   
		($w) = unpack('S',$n);
		$w = $word[$w];


		# See if word fits on line.

   	my $col += length($w) + 1;

   	if ($col >= 65) {
      	$col = 0;
      	$returntext = $returntext . "\n";
   	} else {
      	$returntext = $returntext . ' ';
   	}
   	$returntext = $returntext . $w;

   	# Paragraph every 10 sentences or so. ##amy decreases sentences per paragraph...
   	# if ($w =~ /\.$/)  # origninal statement
		# amy hack below to clear up fooling from U.S. and U.S.A.:
   	if (($w =~ /\.$/) && ($w !~ /^U\.S\./)) {
      	if (rand() < .4) {	# was .3
				$returntext = $returntext . "<P>";
				$col = 100;
      	}
   	}	# end if check for period and not U.S.



  } # end of for loop
  return $returntext;
}



	
sub printselector {
	# subroutine to print the remix console.
	my @corps = keys(%selectfiles); 
	my $optionlist = join ("\n<option>", @corps);
	$optionlist = "\n<option>" . $optionlist . "\n";
	my $optionheader = "<option selected> Select Corporate Artist!\n";
		
	print "Content-type: text/html\n\n";
	print <<"EOF";

<html>
<head>
<title>$jamname</title>
	<LINK href="$infopath/supportfiles/styles.css" type=text/css rel=stylesheet>
	

	<script language="JavaScript">
	<!-- old browser hide
	
	
	
	function validateForm (ourform) {
		var blanks = 0;
		if (ourform.stew.checked == true) {
			return true;
		}	
		
		

		if (ourform.f1.options[0].selected)
			blanks = blanks + 1;
		if (ourform.f2.options[0].selected)	
			blanks = blanks + 1;
		if (ourform.f3.options[0].selected)
			blanks = blanks + 1;
				
		if (blanks > 1) {
		
			return false;
		}
		
		else {

		 return true;	
		 
	  }
	}	
	
	function doStuff(ourform) {
		if (validateForm (ourform) == false) {
		 	alert("Please mix at least two artists - or check the box!");
			return false;
		}
		else {
					
			ourform.submit();
			return true;
		}			 	
	}					
	
	// end old browser hide. -->
	</script>


	
</HEAD>

<BODY leftMargin=0 topMargin=0 marginheight="0" marginwidth="0" bgcolor="black">
<form id="selector" name="selector" method="post" action="$scriptname" onsubmit="return doStuff(this);">

<!-- table nesting for pushing to right -->
<TABLE bgcolor="black">
<TR><TD>&nbsp;<TD>
<TD>
<TABLE cellSpacing=6 cellPadding=10 width="700" height="450" bgColor=black border=0>
 
  <TR> 
      <TD  width="20%" valign="top"  rowspan="2" bgcolor=#FFFF00 height="42">&nbsp;</TD>
      <TD colspan=5 width="80%" valign="top" rowspan="2" bgcolor=#0000FF class="titlebar"><i>The 
        $software!</i></TD>

  </TR>
    
    
 
 <!--need for following row is unexplainable.-->
      <TD width="1"></TD>

 
<TR> 

      <TD colSpan=6 vAlign=center bgColor=#339900 class="montageblock"><IMG height=1 alt="" src="$infopath/supportfiles/clear.gif" width=12 border=0><IMG height=75 alt="" 
      src="$infopath/supportfiles/montage.jpg" width=567 vspace=2 
      border=0></TD>
    
 </TR>
<TR> 
	 	<TD class="textbackground" bgColor=#006600 colspan=6 align=center>
  			<font color="white" face="Arial,Helvetica,Sans-serif">Remix any two or three artists!</font><br>
  		</TD>
</TR>		
    <TR> 
      <TD class="textbackground" colspan=6 align="center" bgColor=#006600> 
        <table width="100%" border="0" cellspacing="6" cellpadding="10" bgColor=#000000>
          <tr>
            <td class="textbackground" align="center" bgColor=#006600>     
			<select name="f1">
	  $optionheader
	  $optionlist
        </select>


			</td>
            
			     <td class="textbackground" align="center" bgColor=#006600>
			 <select name="f2">
	 $optionheader
	 $optionlist

        </select>
		
			
			</td>
         
		 
		 
       <td class="textbackground" align="center" bgColor=#006600>
		 
        <select name="f3">
	 $optionheader
	 $optionlist
        </select>
	 </td>		
	
		 
          </tr>
        </table>
   

    </TR>
    <TR> 
      <TD class="orbox" VALIGN="center" bgcolor=#6600FF width="132"><font face="Arial,Helvetica,Sans-serif">OR... 
        </font></TD>
      <TD VALIGN="center" COLSPAN=5  bgcolor=#339900 class="montageblock"> 

        <font face="Arial,Helvetica,Sans-serif"> 
        <input type="checkbox" name="stew" value="1">
        Check this box for our $allstarjamname! </font> </TD>
    </TR>
 
    <TR> 
      <TD class="mixbox" COLSPAN=6 ALIGN="center" bgColor="red">
        <input type="submit" name="Submit" value="Mix!">
      </TD>
    </TR>
</TABLE>
</TD></TR>
</TABLE>
</form>

</body>
</html>
EOF
}


	 
sub flush {
	 # from the old flush.pl lib from perl dist.
	 # just used by dbg.
    local($old) = select(shift);
    $| = 1;
    print "";
    $| = 0;
    select($old);
} 
	 

sub dbg {
	 # debugging routine, not used by default.
	 # adapted from reamweaver www.reamweaver.com
	 if (!$g_dbg) {return;}
	 #debugging messages
	 my($msg) = @_;
	 my $dbgfile = "/tmp/dbgfile.txt";
	 my $startbit .= " [$$]";
    $startbit .= scalar(localtime);
	 if (!$g_erropen) { 
	 	open (ERR, ">>$dbgfile") || die "couldn't open $dbgfile\n";
		$g_erropen = 1;
	 }	
	 print ERR "$startbit:\n\t\t $msg\n" || die "couldn't print to $dbgfile\n";
	 flush(ERR);
}


sub urlencode {
	# adapted from http://glennf.com/writing/hexadecimal.url.encoding.html
	my $theURL = $_[0];
  	$theURL =~ s/([\W])/"%" . uc(sprintf("%2.2x",ord($1)))/eg;
   return $theURL;
}	
